/**
 * \file sdc_advanced.c
 *
 * \brief Architecture independent part of functions in sdc_advanced.h (excluding config)
 *
 * Redirect of \ref sdc_kernel_version_verify to architecture specific implementation
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#include <private/sdc_advanced.h>
#include <private/sdc_arch.h>

/* Definitions types and defaults */

/* Functions */

sdc_error_t sdc_kernel_version_verify(char **version_info_str)
{
    return sdc_arch_kernel_version_verify(version_info_str);
}
